﻿/*		VERSION:  1.0
	
USAGE:
	#include "functions/brightness.as"
	this.brightness = 100;		// white
	
KNOWN BUGS:
	If the movieClip was dragged to the stage and adjusted to have a negative brightness via the property ribbon instead of code,
	then that brightness will be reset to Zero.
*/
// initial brightness
if(brightness){
	init_brightness = brightness;
}else if(this.transform.colorTransform.redMultiplier==this.transform.colorTransform.greenMultiplier
&& this.transform.colorTransform.redMultiplier==this.transform.colorTransform.blueMultiplier){
	init_brightness = this.transform.colorTransform.redOffset *100 /255;		// scale from 255 to 100 as the max
}else{
	init_brightness = 0;
}



get_brightness = function(){
	return this.transform.colorTransform.redOffset;
}
set_brightness = function( newValue ){
	var alphaScale = _alpha /100;
	var br = newValue *255 /100;		// scale from 100 to 255 as the max;
	this.transform.colorTransform = new flash.geom.ColorTransform( 1,1,1,alphaScale, br,br,br,0);
}// set()
this.addProperty("brightness", get_brightness, set_brightness);
brightness = init_brightness;
delete init_brightness;
delete get_brightness;
delete set_brightness;
